// GLOBALE VARIABLE
var datengeladen = false;
var urlsfetched = false;
var urlliste = [];
var landesurlliste = {};
var landeskuerzel = null;
var openurl = false;
var getlandesurl = false;
var uhr = null;
var win = [];


// NACHRICHTEN von contents.js && popup.js lauschen:
chrome.runtime.onMessage.addListener(function (msg,sender,reply) {
	if((msg.from == 'popup.js') && (msg.subject == 'Popup geladen')) {
		reply({bool:datengeladen, fetched:urlsfetched, daten:JSON.stringify(landesurlliste), land:landeskuerzel});
	} else if ((msg.from == 'popup.js') && (msg.subject == 'URLs hochgeladen')) {
		datengeladen = true;
		urlsfetched = false;
		landeskuerzel = msg.land;
		landesurlliste = JSON.parse(msg.daten);
		urlliste = Object.keys(landesurlliste);
	} else if ((msg.from == 'popup.js') && (msg.subject == 'Landeskürzel geändert')) {
		if(!(landeskuerzel == msg.land)) {
			landeskuerzel = msg.land;
			urlsfetched = false;
		}
	} else if ((msg.from == 'popup.js') && (msg.subject == 'erzeuge Landes-URLs!')) {
		if(!urlsfetched && datengeladen) handler.erzeugen.haupt();
	} else if(openurl && (msg.from == 'content.js') && (msg.subject == 'Inhalt geladen')) {
		openurl = false;
		handler.erzeugen.getlandesurl();
		getlandesurl = true;
	} else if(getlandesurl && (msg.from == 'content.js') && (msg.subject == 'Inhalt geladen')) {
		getlandesurl = false;
		var url = urlliste[uhr.zeit];
		landesurlliste[url].landesurl = msg.url;
		/* if(!(win[uhr.zeit]==null) && !(win[uhr.zeit].window == null)) {
			win[uhr.zeit].window.close();
			win[uhr.zeit] = null;
		} */
		uhr.tick();
		handler.erzeugen.openurl();
		openurl = true;
	} else if(getlandesurl && (msg.from == 'content.js') && (msg.subject == 'ping')) {
		console.log(msg.url);
		console.log(msg.content);
	} else if(getlandesurl && (msg.from == 'content.js') && (msg.subject == 'ping geklicktes Element')) {
		console.log(msg.url);
		console.log(msg.data);
		console.log(msg.el);
	}
});


var handler = {
	'erzeugen': {
		'haupt': function() {
			uhr = handler.ticker(this,urlliste.length,response.progress,response.progress,function(t,T) {
				response.progress(t,T);
				response.output();
			});
			urlsfetched = false;
			openurl = true;
			getlandesurl = false;
			handler.erzeugen.openurl();
		},
		'openurl': function() {
			if(uhr.zeit<uhr.end) {
				var url = urlliste[uhr.zeit];
				win.push(window.open(url,'_blank'));
			} else {
				uhr.tick();
			}
		},
		'getlandesurl': function() {
			if(uhr.zeit<uhr.end) {
				var url = urlliste[uhr.zeit];
				chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
					chrome.tabs.sendMessage(tabs[0].id, {
						from: 'popup.js',
						to: 'content.js',
						subject: 'ändere das Land!',
						url: url,
						kuerzel: landeskuerzel,
					});
				});
			}
		},
	},
	'ticker': function(self,T,s,m,e) {
		if(s == null) s = function() {};
		if(m == null) m = function() {};
		if(e == null) e = function() {};
		var S = (function(self) {
			return function(t,T) {
				s.call(self,t,T);
			};
		})(self);
		var M = (function(self) {
			return function(t,T) {
				m.call(self,t,T);
			};
		})(self);
		var E = (function(self) {
			return function(t,T) {
				e.call(self,t,T);
			};
		})(self);
		var u = new Ticker(self,T,S,M,E);
		u.set();
		return u;
	},
};


var response = {
	'progress': function(t,T) {
		console.log('Fortschritt: '+t+'/'+T+'; '+Math.round(100*t/T)+'%');
		chrome.runtime.sendMessage({from: 'background.js', to: 'popup.js', subject: 'Fortschritt bei der Erzeugung von Landes-URLs', zeit:t, ende:T});
	},
	'output': function() {
		win = [];
		urlsfetched = true;
		console.log('LandesURLs wurden erhalten.');
		chrome.runtime.sendMessage({from: 'background.js', to: 'popup.js', subject: 'Landes-URLs generiert', daten: JSON.stringify(landesurlliste), land:landeskuerzel});
	},
}